/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer.include;

import java.io.IOException;
import java.net.URI;
import java.util.stream.Stream;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.streams.Steps;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.writer.include.IncludeFilter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

final class IncludeXml {
    private final Job job;
    private final URI currentFile;
    private final ContentHandler contentHandler;
    private final DITAOTLogger logger;

    IncludeXml(Job job, URI currentFile, ContentHandler contentHandler, DITAOTLogger logger) {
        this.job = job;
        this.currentFile = currentFile;
        this.contentHandler = contentHandler;
        this.logger = logger;
    }

    boolean include(Attributes atts) {
        URI hrefValue = URLUtils.toURI(atts.getValue("href"));
        Job.FileInfo fileInfo = this.job.getFileInfo(URLUtils.stripFragment(this.currentFile.resolve(hrefValue)));
        try {
            XdmNode src;
            XdmNode doc = this.job.getStore().getImmutableNode(fileInfo.src);
            if (hrefValue.getFragment() != null) {
                XdmAtomicValue id = XdmAtomicValue.makeAtomicValue((Object)hrefValue.getFragment());
                Stream idStream = (Stream)Steps.id((XdmNode)doc).apply((Object)id);
                src = idStream.findAny().orElse(doc);
            } else {
                src = doc;
            }
            this.job.getStore().writeDocument(src, (ContentHandler)new IncludeFilter(this.contentHandler));
        }
        catch (IOException e) {
            this.logger.error("Failed to process include {}", fileInfo.src, e);
            return false;
        }
        return true;
    }
}

