/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown.renderer;

import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.util.ast.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class Title {
    final Collection<String> classes;
    final Map<String, String> attributes;
    final Optional<String> id;

    private Title(List<AttributesNode> attributesNodes) {
        this.classes = this.getClasses(attributesNodes);
        this.attributes = Title.getAttributes(attributesNodes);
        this.id = Title.getId(attributesNodes);
    }

    public static Title getFromNext(Node node) {
        return new Title(Title.getNextAttributesNodes(node));
    }

    public static Title getFromChildren(Node node) {
        return new Title(Title.getPreviousAttributesNodes(node));
    }

    private static List<AttributesNode> getNextAttributesNodes(Node current) {
        ArrayList<AttributesNode> res = new ArrayList<AttributesNode>();
        Node node = current.getNext();
        while (node instanceof AttributesNode) {
            res.add((AttributesNode)node);
            node = node.getNext();
        }
        return res;
    }

    private static List<AttributesNode> getPreviousAttributesNodes(Node current) {
        ArrayList<AttributesNode> res = new ArrayList<AttributesNode>();
        for (Node node = current.getLastChild(); node != null && node instanceof AttributesNode; node = node.getPrevious()) {
            res.add((AttributesNode)node);
        }
        Collections.reverse(res);
        return res;
    }

    private static Map<String, String> getAttributes(List<AttributesNode> attributesNodes) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (AttributesNode attributesNode : attributesNodes) {
            for (Node child : attributesNode.getChildren()) {
                AttributeNode attributeNode;
                if (!(child instanceof AttributeNode) || Title.isClass(attributeNode = (AttributeNode)child) || Title.isId(attributeNode)) continue;
                res.put(attributeNode.getName().toString(), attributeNode.getValue().toString());
            }
        }
        return res;
    }

    private static Optional<String> getId(List<AttributesNode> attributesNodes) {
        for (AttributesNode attributesNode : attributesNodes) {
            for (Node child : attributesNode.getChildren()) {
                AttributeNode attributeNode;
                if (!(child instanceof AttributeNode) || !Title.isId(attributeNode = (AttributeNode)child)) continue;
                return Optional.of(attributeNode.getValue().toString());
            }
        }
        return Optional.empty();
    }

    private static boolean isId(AttributeNode attributeNode) {
        return attributeNode.getName().toString().equals("#") || attributeNode.getName().toString().equals("id");
    }

    private List<String> getClasses(List<AttributesNode> attributesNodes) {
        ArrayList<String> res = new ArrayList<String>();
        for (AttributesNode attributesNode : attributesNodes) {
            for (Node child : attributesNode.getChildren()) {
                AttributeNode attributeNode;
                if (!(child instanceof AttributeNode) || !Title.isClass(attributeNode = (AttributeNode)child)) continue;
                res.add(attributeNode.getValue().toString());
            }
        }
        return res;
    }

    private static boolean isClass(AttributeNode attributeNode) {
        return attributeNode.getName().toString().equals(".") || attributeNode.getName().toString().equals("class");
    }
}

